/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CCRSNetscapeServer.h,v 1.2 2000/07/10 22:04:59 dallen Exp $
____________________________________________________________________________*/

#ifndef Included_CCRSNetscapeServer_h
#define Included_CCRSNetscapeServer_h

#include "CCRSServer.h"

class CCRSNetscapeServer : public CCRSServer {
public:
					CCRSNetscapeServer(PGPContextRef inContext,
						const char * inHostName, PGPUInt32 inHostAddress,
						PGPUInt16 inHostPort, const char * inPath,
						PGPKeyServerProtocol inProtocol,
						PGPKeyServerClass inClass);
	virtual			~CCRSNetscapeServer();
	
	virtual void	SendCertificateRequest(PGPKeyDBObjRef inCAKey, PGPKeyDBObjRef inRequestKey, 
						const void * inBuffer, PGPSize inBufferSize, void ** outBuffer,
						PGPSize * outBufferSize);
	virtual void	RetrieveCertificate(PGPFilterRef inSearchFilter, PGPKeyDBObjRef inSearchKey,
	    					PGPKeyDBObjRef inCAKey,
						PGPKeyDBObjRef inSigningKey, PGPByte * inPassphrase,
						PGPSize inPassphraseLength, PGPBoolean inIsPassphrase,
						void ** outBuffer, PGPSize * outBufferSize);
	virtual void	RetrieveCRL(PGPKeyDBObjRef inCAKey, PGPKeyDBObjRef inSigningKey,
						PGPByte * inPassphrase, PGPSize inPassphraseLength,
						PGPBoolean inIsPassphrase, void ** outBuffer, PGPSize * outBufferSize);

protected:
	PGPUInt32		PostCRSMessage(PGPKeyServerState inOperation, const char * inPath,
						PGPByte** outResult, PGPUInt32 inContentLength,
						const PGPByte * inData);

	void			PackageAndSendCRSMessage(PGPExportFormat inExportFormat,
						PGPOutputFormat inOutputFormat, PGPKeyDBObjRef inKey,
						PGPKeyDBObjRef inCAKey, PGPKeyDBObjRef inSigningKey,
						PGPByte * inPassphrase, PGPSize inPassphraseLength,
						PGPBoolean inIsPassphrase, void ** outBuffer, PGPSize * outBufferSize);
};



#endif
